require("scripts/chocshopstyle.lua");

PI = 3.1415926535;

default_tutorial_assets = {
	baseDir = "ui/tutorials/",
	background = {
		{ state = "default", file="tutorial_back", anim=false },
	},
};

default_arrow = {
    baseDir = "ui/tutorials/",
    continuous = true,
    assets = {
        arrow = {
		    { state = "default", file="tutorial_arrow" },
	    },
    },
};

indicator_arrow = {
    baseDir = "ui/tutorials/",
    tint = FColor(1.0, 0.3, 0.6),
    scale = {0.7,0.7},
    assets = {
        arrow = {
		    { state = "default", file="tutorial_arrow" },
	    },
    },
};

tutorial_skip_button = {
    name = "tutorial_skip",
    baseDir = "ui/buttons/",
    x = 20, y = 575,
    scale = 0.7,
    clickable = true,
    assets = {
        default = {
            { state="default", file="hud_menu", anim=false },
            { state="over", file="hud_menu_over", anim=false },
            { state="down", file="hud_menu_over", anim=false },
        }
    },
    text = {
        skip_label = {
            x = 20, y = -8, w = 200, h = 25,
            font = {edwardian_medium, 18, BlackColor},
            flags = kVAlignTop + kHAlignLeft,
            label ="app_skiptutorials",
            outline = {WhiteColor, 1},
        }
    }
};
advance_button_style = {
    name = "button_advance",
    type = "button",
    baseDir = "ui/buttons/",
    x = 20, y = 20,
    scale = {0.7, 0.7},
    assets = {
        default = {
            { state="default", file="hud_menu", anim=false },
            { state="over", file="hud_menu_over", anim=false },
            { state="down", file="hud_menu_over", anim=false },
        }
    },
    text = {
        skip_label = {
            x = 25, y = -10, w = 200, h = 30,
            font = {edwardian_medium, 20, WhiteColor},
            flags = kVAlignTop + kHAlignLeft,
            label ="btn_continue",
            outline = {BlackColor, 1},
            margin = {0,0,0,0},
        }
    }
};

tutorial_text_style = {
    x1 = 68, y1 = 68, x2 = 44, y2 = 46,
    font = {edwardian_medium, 15, BlackColor},
	margin = {40,50,40,35},
};
------------------------------------------------------------------------------------
-- Game Tutorials 
------------------------------------------------------------------------------------
game_tutorials = {
    modes = {0},
    tutorial_upgrades = {
        window = "prelevel_container",
        trigger_type = "upgrade_dialog",
        tryonce = true,
        dim = false,
        minlevel = 4,
        maxlevel = 4,
        assets = default_tutorial_assets,
        skip = tutorial_skip_button,
        steps = {
            {
                x = 350, y = 75, w = 250, h = 270,
                style = tutorial_text_style,
                label ="tutorial_upgrade_1",
                trigger_objects = { {"toggle_upgrades_aesthetic", kClick } },
				children = {
				    arrow = {style = default_arrow, x = 105, y = 92},
				}
            },
		    {               
		        x = 365, y = 75, w = 250, h = 275,
                style = tutorial_text_style,
                label ="tutorial_upgrade_2",
                trigger_objects = { {"btn_buy_upgrade", kClick }, {"upgrade_list", kNoTrigger}, {"prelevel_background", kIgnore} },
				children = {
					arrow = {style = indicator_arrow, x = 305, y = 226, rotation ={0,0,1.570}},
				}
            },
           	{
                x = 350, y = 75, w = 250, h = 235,
                style = tutorial_text_style,
                label ="tutorial_upgrade_4",
                trigger_objects = { {"toggle_upgrades_gameplay", kClick } },
				children = {
				    arrow = {style = default_arrow, x = 190, y = 92},
				}
            },
		    {                
		        x = 350, y = 75, w = 250, h = 200,
                style = tutorial_text_style,
                label ="tutorial_upgrade_5",
                trigger_objects = { {"btn_buy_upgrade", kClick}, {"upgrade_list", kNoTrigger}, {"prelevel_background", kIgnore} },
                children = {
					arrow = {style = indicator_arrow, x = 305, y = 226, rotation ={0,0,1.570}},
				}
            },
            {
                x = 350, y = 75, w = 250, h = 200,
                style = tutorial_text_style,
                label ="tutorial_upgrade_7",
                trigger_objects = { {"toggle_upgrades_player", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 275, y = 92},
				}
            },
		    {                
		        x = 350, y = 75, w = 250, h = 200,
                style = tutorial_text_style,
                label ="tutorial_upgrade_8",
                trigger_objects = { {"btn_buy_upgrade", kClick}, {"upgrade_list", kNoTrigger}, {"prelevel_background", kIgnore} },
                children = {
					arrow = {style = indicator_arrow, x = 305, y = 226, rotation = {0,0,1.570}},
				}
            },
		    {                
		        x = 350, y = 75, w = 250, h = 200,
                style = tutorial_text_style,
                label ="tutorial_upgrade_10",
                trigger_objects = { {"ok_button", kClick} },
                children = {
				    arrow = {style = default_arrow, x = 740, y = 510},
				}
            },
        },
    },
	tutorial_1 = {
		trigger_object = "tut_cust_1",
		trigger_type = "customer_arrival",		
		minlevel = 1,
		maxlevel = 1,
		repeatable = true,
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		highlight_objects = {"avatar"},
		steps = {
			{
				x = 125, y = 17,
				w = 200, h = 185,
				style = tutorial_text_style,
				label ="tutorial_1_1",
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 71, y = 175},
				}
			},
			{
				x = 125, y = 17,
				w = 200, h = 165,
				style = tutorial_text_style,
				label ="tutorial_1_2",
				trigger_objects = { {"tut_cust_1", kResume, action=false} },
			},
			{
				x = 440, y = 100,
				w = 240, h = 165,
				style = tutorial_text_style,
				label ="tutorial_1_3",
				action_objects = {"machine_sauce"},
				trigger_objects = { {"station08", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 700, y = 200},
				}
			},
			{
				x = 125, y = 17,
				w = 200, h = 165,
				style = tutorial_text_style,
				label ="tutorial_1_5",
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 71, y = 175},
				}
			},
			{			
				x = 155, y = 17,
				w = 200, h = 175,
				style = tutorial_text_style,
				label ="tutorial_1_6",
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 126, y = 275},
				}
			},
		},
	},
	tutorial_2 = {
		trigger_object = "tut_cust_2",
		trigger_type = "customer_arrival",
		minlevel = 1,
		maxlevel = 1,
		repeatable = true,
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		highlight_objects = {"avatar"},
		steps = {
			{
				x = 225, y = 17,
				w = 200, h = 195,
				style = tutorial_text_style,
				label ="tutorial_1_7",
				action_objects = {"tut_cust_2"},
				trigger_objects = { {"station02", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 171, y = 100},
				}
			},
			{
				pause = false,
				x = 225, y = 17,
				w = 200, h = 165,
				style = tutorial_text_style,
				label ="tutorial_1_2",
				trigger_objects = { {"tut_cust_2", kResume, action=false} },
			},
			{
				x = 240, y = 410,
				w = 200, h = 175,
				label ="tutorial_1_8",
				style = tutorial_text_style,
				highlight_objects = {"avatar", "tut_cust_2"},
				trigger_objects = { {"btn_mix_dark", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 74, y = 495},
				    arrow2 = {style = indicator_arrow, x = 133, y = 62, rotation ={0,0,-0.785}},
				}
			},
			{
				x = 240, y = 410,
				w = 200, h = 165,
				label ="tutorial_1_4",
				style = tutorial_text_style,
				trigger_objects = { {"station14", kResume, action=false} },
			},
			{
				x = 240, y = 410,
				w = 200, h = 165,
				label ="tutorial_1_11",
				style = tutorial_text_style,
				action_objects = {"machine_mixer"},
				trigger_objects = { {"station14", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 200, y = 430},
				}
			},
			{
				x = 575, y = 410,
				w = 200, h = 165,
				label ="tutorial_1_9",
				style = tutorial_text_style,
				trigger_objects = { {"press_btn_1", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 455, y = 550},
				}
			},
			{
			    trigger_objects = { {"station12", kResume, action=false} },
			},
			{
				x = 575, y = 410,
				w = 200, h = 165,
				label ="tutorial_1_12",
				style = tutorial_text_style,
				action_objects = {"machine_press"},
				trigger_objects = { {"station12", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 495, y = 495},
				}
			},
			{
				x = 225, y = 17,
				w = 200, h = 195,
				style = tutorial_text_style,
				label ="tutorial_1_5",
				action_objects = {"tut_cust_2"},
				trigger_objects = { {"station02", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 171, y = 100},
				}
			},
			{
				x = 265, y = 17,
				w = 225, h = 195,
				style = tutorial_text_style,
				label ="tutorial_1_13",
				action_objects = {"tut_cust_2"},
				trigger_objects = { {"station02", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 191, y = 225},
				}
			},
		},
	},
	tutorial_3 = { 
		trigger_object = "tut_cust_3",
		trigger_type = "customer_arrival",	
		minlevel = 1,
		maxlevel = 1,
		repeatable = true,
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		highlight_objects = {"avatar"},
		steps = {
			{
				x = 125, y = 17,
				w = 245, h = 175,
				style = tutorial_text_style,
				label ="tutorial_1_14",
				action_objects = {"tut_cust_3"},
				trigger_objects = { {"station01", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 71, y = 175},
				}
			},
			{
				pause = false,
				x = 225, y = 17,
				w = 200, h = 165,
				style = tutorial_text_style,
				label ="tutorial_1_15",
				highlight_objects = {"avatar", "tut_cust_3"},
				action_objects = {"tut_cust_4"},
				trigger_objects = { {"station02", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 160, y = 105},
				}
			},
			{
				pause = false,
				x = 225, y = 17,
				w = 200, h = 185,
				style = tutorial_text_style,
				label ="tutorial_1_24",
				highlight_objects = {"avatar", "tut_cust_3"},
				trigger_objects = { {"tut_cust_4", kResume, action=false} },
			},
			{
				x = 450, y = 100,
				w = 200, h = 250,
				style = tutorial_text_style,
				label ="tutorial_1_16",
				action_objects = {"machine_sauce"},
				trigger_objects = { {"station08", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 700, y = 200},
				}
			},
			{
				x = 125, y = 17,
				w = 200, h = 165,
				style = tutorial_text_style,
				label ="tutorial_1_19",
				action_objects = {"tut_cust_3"},
				trigger_objects = { {"station01", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 71, y = 175},
				}
			},
			{
				x = 240, y = 340,
				w = 200, h = 235,
				label ="tutorial_1_23",
				style = tutorial_text_style,
				trigger_objects = { {"btn_mix_dark", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 74, y = 495},
				}
			},
			{
			    trigger_objects = { {"station14", kResume, action=false} },
			},
			{
				x = 240, y = 410,
				w = 200, h = 165,
				label ="tutorial_1_11",
				style = tutorial_text_style,
				action_objects = {"machine_mixer"},
				trigger_objects = { {"station14", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 200, y = 430},
				}
			},
			{
				x = 575, y = 410,
				w = 200, h = 165,
				label ="tutorial_1_9",
				style = tutorial_text_style,
				trigger_objects = { {"press_btn_1", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 455, y = 550},
				}
			},
			{
			    trigger_objects = { {"station12", kResume, action=false} },
			},
			{
				x = 575, y = 410,
				w = 200, h = 165,
				label ="tutorial_1_12",
				style = tutorial_text_style,
				action_objects = {"machine_press"},
				trigger_objects = { {"station12", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 495, y = 495},
				}
			},
			{
				x = 225, y = 17,
				w = 200, h = 195,
				style = tutorial_text_style,
				label ="tutorial_1_20",
				action_objects = {"tut_cust_4"},
				trigger_objects = { {"station02", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 171, y = 100},
				}
			},
			{
				x = 265, y = 17,
				w = 235, h = 195,
				style = tutorial_text_style,
				label ="tutorial_1_21",
				action_objects = {"tut_cust_4"},
				trigger_objects = { {"station02", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 191, y = 225},
				}
			},
			{
				x = 155, y = 17,
				w = 207, h = 182,
				style = tutorial_text_style,
				label ="tutorial_1_22",
				action_objects = {"tut_cust_3"},
				trigger_objects = { {"station01", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 126, y = 275},
				}
			},
		},
	},
	tutorial_4 = {
		trigger_object = "tut_cust_1",
		trigger_type = "customer_arrival",
		minlevel = 2,
		maxlevel = 2,
		repeatable = true,
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		highlight_objects = {"avatar"},
		steps = {
			{
				x = 240, y = 340,
				w = 200, h = 245,
				label ="tutorial_2_1",
				style = tutorial_text_style,
				trigger_objects = { {"btn_mix_dark", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 74, y = 495},
				}
			},
			{
			    trigger_objects = { {"station14", kResume, action=false} },
			},
			{
				x = 240, y = 410,
				w = 200, h = 165,
				label ="tutorial_1_11",
				style = tutorial_text_style,
				action_objects = {"machine_mixer"},
				trigger_objects = { {"station14", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 200, y = 430},
				}
			},
			{
				x = 575, y = 410,
				w = 200, h = 165,
				label ="tutorial_1_9",
				style = tutorial_text_style,
				trigger_objects = { {"press_btn_1", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 455, y = 550},
				}
			},
			{
			    trigger_objects = { {"station12", kResume, action=false} },
			},
			{
				x = 575, y = 410,
				w = 185, h = 155,
				label ="tutorial_1_12",
				style = tutorial_text_style,
				action_objects = {"machine_press"},
				trigger_objects = { {"station12", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 495, y = 495},
				}
			},
			{
				x = 500, y = 140,
				w = 185, h = 165,
				style = tutorial_text_style,
				label ="tutorial_2_2",
				trigger_objects = { {"station16", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 415, y = 290},
				}
			},
			{
				x = 500, y = 140,
				w = 200, h = 280,
				style = tutorial_text_style,
				label ="tutorial_2_3",
				trigger_objects = { {"station16", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 415, y = 290},
				}
			},
			{
				x = 150, y = 120,
				w = 225, h = 195,
				style = tutorial_text_style,
				label ="tutorial_2_4",
				trigger_objects = { {"station15", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 110, y = 315},
				}
			},

		},
	},
	tutorial_5 = { 
		trigger_object = "tut_cust_1",
		trigger_type = "customer_arrival",
		minlevel = 3,
		maxlevel = 3,
		repeatable = true,
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		highlight_objects = {"avatar"},
		steps = {
		    {
				dim = false,
				skip = false,
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
			},
			{
				dim = false,
				pause = false,
				skip = false,
				trigger_objects = { {"tut_cust_1", kResume, action=false} },
			},
			{
				x = 240, y = 290,
				w = 250, h = 175,
				label ="tutorial_3_2",
				style = tutorial_text_style,
				highlight_objects = {"avatar", "tut_cust_1"},
				trigger_objects = { {"btn_mix_dark", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 74, y = 495},
				    arrow2 = {style = indicator_arrow, x = 58, y = 120},
				}
			},
			{
			    trigger_objects = { {"station14", kResume, action=false} },
			},
			{
				x = 290, y = 310,
				w = 200, h = 165,
				label ="tutorial_1_11",
				style = tutorial_text_style,
				action_objects = {"machine_mixer"},
				trigger_objects = { {"station14", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 200, y = 430},
				}
			},
			{
				x = 340, y = 350,
				w = 200, h = 165,
				label ="tutorial_3_3",
				style = tutorial_text_style,
				trigger_objects = { {"btn_ingred_1", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 260, y = 545},
				}
			},
			{
			    trigger_objects = { {"station13", kResume, action=false} },
			},
			{
				x = 370, y = 350,
				w = 200, h = 165,
				label ="tutorial_3_9",
				style = tutorial_text_style,
				action_objects = {"machine_ingredient"},
				trigger_objects = { {"station13", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 315, y = 460},
				}
			},
			{
				x = 575, y = 410,
				w = 200, h = 165,
				label ="tutorial_3_4",
				style = tutorial_text_style,
				trigger_objects = { {"press_btn_1", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 455, y = 550},
				}
			},
			{
			    trigger_objects = { {"station12", kResume, action=false} },
			},
			{
				x = 575, y = 410,
				w = 200, h = 165,
				label ="tutorial_3_6",
				style = tutorial_text_style,
				action_objects = {"machine_press"},
				trigger_objects = { {"station12", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 495, y = 495},
				}
			},
			{
				x = 125, y = 17,
				w = 245, h = 175,
				style = tutorial_text_style,
				label ="tutorial_3_7",
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 71, y = 175},
				}
			},
			
		},
	},
	tutorial_6 = {
		trigger_object = "tut_cust_1",
		trigger_type = "customer_arrival",
		minlevel = 61,
		maxlevel = 61,
		repeatable = true,
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		highlight_objects = {"avatar"},
		steps = {
		    {
				dim = false,
				skip = false,
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
			},
			{
				dim = false,
				pause = false,
				skip = false,
				trigger_objects = { {"tut_cust_1", kResume, action=false} },
			},
			{
				x = 240, y = 410,
				w = 260, h = 175,
				label ="tutorial_4_2",
				style = tutorial_text_style,
				highlight_objects = {"avatar", "tut_cust_1"},
				trigger_objects = { {"btn_mix_milk", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 115, y = 505},
				    arrow2 = {style = indicator_arrow, x = 58, y = 120},
				}
			},
			{
			    trigger_objects = { {"station14", kResume} },
			},
			{
				x = 240, y = 410,
				w = 200, h = 165,
				label ="tutorial_4_3",
				style = tutorial_text_style,
				action_objects = {"machine_mixer"},
				trigger_objects = { {"station14", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 200, y = 430},
				}
			},
			{
				x = 575, y = 410,
				w = 200, h = 165,
				label ="tutorial_3_4",
				style = tutorial_text_style,
				trigger_objects = { {"press_btn_1", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 455, y = 550},
				}
			},
			{
			    trigger_objects = { {"station12", kResume, action=false} },
			},
			{
				x = 575, y = 410,
				w = 200, h = 165,
				label ="tutorial_4_4",
				style = tutorial_text_style,
				action_objects = {"machine_press"},
				trigger_objects = { {"station12", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 495, y = 495},
				}
			},
			{
				x = 125, y = 17,
				w = 245, h = 175,
				style = tutorial_text_style,
				label ="tutorial_3_7",
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 71, y = 175},
				}
			},
		},
	},

	--[[tutorial_7 = {
		trigger_object = "tut_cust_1",
		trigger_type = "customer_arrival",
		minlevel = 5,
		maxlevel = 5,
		repeatable = true,
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		highlight_objects = {"avatar"},
		steps = {
		    {
				dim = false,
				skip = false,
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
			},
			{
				dim = false,
				pause = false,
				skip = false,
				trigger_objects = { {"tut_cust_1", kResume, action=false} },
			},
			{
				x = 240, y = 410,
				w = 270, h = 175,
				label ="tutorial_5_2",
				style = tutorial_text_style,
				highlight_objects = {"avatar", "tut_cust_1"},
				trigger_objects = { {"btn_mix_milk", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 115, y = 505},
				    arrow2 = {style = indicator_arrow, x = 58, y = 120},
				}
			},
			{
			    trigger_objects = { {"station14", kResume, action=false} },
			},
			{
				x = 290, y = 310,
				w = 200, h = 165,
				label ="tutorial_4_3",
				style = tutorial_text_style,
				action_objects = {"machine_mixer"},
				trigger_objects = { {"station14", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 200, y = 430},
				}
			},
			{
				x = 575, y = 410,
				w = 200, h = 165,
				label ="tutorial_5_3",
				style = tutorial_text_style,
				trigger_objects = { {"press_btn_2", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 497, y = 549},
				}
			},
			{
			    trigger_objects = { {"station12", kResume, action=false} },
			},
			{
				x = 575, y = 410,
				w = 200, h = 165,
				label ="tutorial_5_4",
				style = tutorial_text_style,
				action_objects = {"machine_press"},
				trigger_objects = { {"station12", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 495, y = 495},
				}
			},
			{
				x = 125, y = 17,
				w = 245, h = 175,
				style = tutorial_text_style,
				label ="tutorial_5_5",
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 71, y = 175},
				}
			},
		},
	},]]

	tutorial_8 = {
		trigger_object = "tut_cust_1",
		trigger_type = "customer_arrival",
		minlevel = 13,
		maxlevel = 13,
		repeatable = true,
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		highlight_objects = {"avatar"},
		steps = {
		    {
				dim = false,
				skip = false,
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
			},
			{
				dim = false,
				pause = false,
				skip = false,
				trigger_objects = { {"tut_cust_1", kResume, action=false} },
			},
			{
				x = 240, y = 290,
				w = 256, h = 175,
				label ="tutorial_6_2",
				style = tutorial_text_style,
				highlight_objects = {"avatar", "tut_cust_1"},
				trigger_objects = { {"btn_mix_dark", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 74, y = 495},
				    arrow2 = {style = indicator_arrow, x = 58, y = 120},
				}
			},
			{
			    trigger_objects = { {"station14", kResume, action=false} },
			},
			{
				x = 290, y = 310,
				w = 200, h = 165,
				label ="tutorial_1_11",
				style = tutorial_text_style,
				action_objects = {"machine_mixer"},
				trigger_objects = { {"station14", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 200, y = 430},
				}
			},
			{
				x = 440, y = 150,
				w = 200, h = 165,
				label ="tutorial_8_3_1",
				style = tutorial_text_style,
				trigger_objects = { {"btn_infuse_1", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 779, y = 335},
				}
			},
			{
			    trigger_objects = { {"station10", kResume, action=false} },
			},
			{
				x = 440, y = 150,
				w = 200, h = 165,
				label ="tutorial_8_5",
				style = tutorial_text_style,
				action_objects = {"machine_infusion"},
				trigger_objects = { {"station10", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 730, y = 305},
				}
			},
			{
				x = 550, y = 150,
				w = 200, h = 165,
				label ="tutorial_6_3",
				style = tutorial_text_style,
				trigger_objects = { {"btn_topping_1", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 628, y = 545},
				}
			},
			{
			    trigger_objects = { {"station11", kResume, action=false} },
			},
			{
				x = 550, y = 150,
				w = 200, h = 165,
				label ="tutorial_6_5",
				style = tutorial_text_style,
				action_objects = {"machine_topping"},
				trigger_objects = { {"station11", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 610, y = 460},
				}
			},
			{
				x = 125, y = 17,
				w = 245, h = 185,
				style = tutorial_text_style,
				label ="tutorial_6_6",
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 71, y = 175},
				}
			},
		},
	},

	tutorial_9 = {
		trigger_object = "tut_cust_1",
		trigger_type = "customer_arrival",
		minlevel = 11,
		maxlevel = 11,
		repeatable = true,
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		highlight_objects = {"avatar"},
		steps = {
		    {
				dim = false,
				skip = false,
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
			},
			{
				dim = false,
				pause = false,
				skip = false,
				trigger_objects = { {"tut_cust_1", kResume, action=false} },
			},
			{
				x = 240, y = 290,
				w = 255, h = 200,
				label ="tutorial_8_2",
				style = tutorial_text_style,
				highlight_objects = {"avatar", "tut_cust_1"},
				trigger_objects = { {"btn_mix_dark", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 74, y = 495},
				    arrow2 = {style = indicator_arrow, x = 58, y = 120},
				}
			},
			{
			    trigger_objects = { {"station14", kResume, action=false} },
			},
			{
				x = 240, y = 410,
				w = 200, h = 165,
				label ="tutorial_1_11",
				style = tutorial_text_style,
				action_objects = {"machine_mixer"},
				trigger_objects = { {"station14", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 200, y = 430},
				}
			},
			{
				x = 550, y = 150,
				w = 205, h = 195,
				label ="tutorial_8_3",
				style = tutorial_text_style,
				trigger_objects = { {"btn_infuse_1", kClick} },
				children = {
				    arrow = {style = default_arrow, x = 780, y = 345},
				}
			},
			{
			    trigger_objects = { {"station10", kResume, action=false} },
			},
			{
				x = 440, y = 150,
				w = 200, h = 165,
				label ="tutorial_8_5",
				style = tutorial_text_style,
				action_objects = {"machine_infusion"},
				trigger_objects = { {"station10", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 730, y = 305},
				}
			},
			{
				x = 125, y = 17,
				w = 250, h = 200,
				style = tutorial_text_style,
				label ="tutorial_8_6",
				action_objects = {"tut_cust_1"},
				trigger_objects = { {"station01", kArrival} },
				children = {
				    arrow = {style = default_arrow, x = 71, y = 175},
				}
			},
		},
	},
	tutorial_endless_1 = {
	    trigger_type = "endless_start",
		minlevel = 1,
		maxlevel = 100,
		pause = true,
		--repeatable = true,
		modes = {1,2,3},
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		steps = {
			{
			    x = 380, y = 150,
			    w = 300, h = 230,
			    style = tutorial_text_style,
			    flags = kHAlignCenter + kVAlignTop,
			    label = "tutorial_endless_1",
			    trigger_objects = { {"button_advance", kClick} },
			    button = {style = advance_button_style, x = 45, y = 185},
			    children = {
				    arrow = {style = indicator_arrow, x = 762, y = 188, rotation = {0,0, PI}},
			    }
			},
			{
			    x = 380, y = 150,
			    w = 300, h = 250,
			    style = tutorial_text_style,
			    flags = kHAlignCenter + kVAlignTop,
			    label ="tutorial_endless_2",
			    trigger_objects = { {"button_advance", kClick} },
			    button = {style = advance_button_style, x = 45, y = 205},
			    children = {
				    arrow = {style = indicator_arrow, x = 657, y = 94, rotation = {0,0,-PI*3.0/4.0} },
			    }
			}
		}
	},
	tutorial_endless_2 = {
		minlevel = 1,
		maxlevel = 100,
		pause = true,
		--repeatable = true,
		modes = {1,2,3},
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		steps = {
			{
			    x = 50, y = 50,
			    w = 300, h = 230,
			    style = tutorial_text_style,
			    flags = kHAlignCenter + kVAlignTop,
			    label ="tutorial_endless_3",
			    trigger_objects = { {"button_advance", kClick} },
			    button = {style = advance_button_style, x = 45, y = 185},
			    children = {
				    --arrow = {style = default_arrow, x = 71, y = 175},
			    }
			}
		}
	},
	--[[
	tutorial_zepplin = {
		trigger_object = "tut_cust_1",
		minlevel = 14,
		maxlevel = 14,
		assets = default_tutorial_assets,
		skip = tutorial_skip_button,
		steps = {
			{
				x = 125, y = 17,
				w = 250, h = 175,
				style = tutorial_text_style,
				label ="tutorial_8_1",
				objects = {"station01", kClick, "tut_cust_1", kClick, "avatar"},
				arrow = {71,175},
			},
			{
				pause = false,
				x = 125, y = 17,
				w = 200, h = 175,
				style = tutorial_text_style,
				label ="tutorial_1_2",
				objects = {"station01", kNoTrigger, "tut_cust_1", kResume, "avatar"},
			},
		},
	},
	]]
} 
